@echo off
setlocal
set ROOT=%~dp0
set FORENSIC_KIT_ROOT=%ROOT%
set FORENSIC_STATIC_ROOT=%ROOT%static
if exist "%ROOT%vendor_signing_ed25519.pub" (
  set FORENSIC_VENDOR_PUBKEY=%ROOT%vendor_signing_ed25519.pub
)
if exist "%ROOT%proof-rules.enc" (
  set FORENSIC_RULES_ROOT=%ROOT%proof-rules.enc
) else (
  set FORENSIC_RULES_ROOT=%ROOT%proof-rules
)
set FORENSIC_BUNDLE_ROOT=%ROOT%bundles
if not exist "%FORENSIC_BUNDLE_ROOT%" mkdir "%FORENSIC_BUNDLE_ROOT%"
set REQUEST_DIR=%FORENSIC_BUNDLE_ROOT%requests
if exist "%ROOT%license-request.json" (
  if not exist "%REQUEST_DIR%" mkdir "%REQUEST_DIR%"
  move /Y "%ROOT%license-request.json" "%REQUEST_DIR%\\license-request.json" >nul
  echo Moved license-request.json to %REQUEST_DIR%\\license-request.json to preserve kit integrity.
)
for /f "delims=" %%F in ('dir /b /o-d "%ROOT%LIC_*.signed.json" 2^>nul') do (
  set FORENSIC_LICENSE_FILE=%ROOT%%%F
  goto :foundlicense
)
if not exist "%REQUEST_DIR%" mkdir "%REQUEST_DIR%"
set FORENSIC_LICENSE_REQUIRED=0
echo No license found. Generating request at %REQUEST_DIR%\\license-request.json
%ROOT%legacy-lens.exe fingerprint --request "%REQUEST_DIR%\\license-request.json"
echo Send this request to your vendor issuance desk.
echo Vendor returns LIC_*.signed.json. Place it in %ROOT%
echo Then re-run: run.bat
exit /b 2
:foundlicense
set FORENSIC_LICENSE_REQUIRED=1
set FORENSIC_HARDWARE_REQUIRED=1
set FORENSIC_KIT_BIND_REQUIRED=1
if "%FORENSIC_BIND%"=="" set FORENSIC_BIND=127.0.0.1:8080
echo Legacy Lens server starting on %FORENSIC_BIND%
echo Open http://%FORENSIC_BIND%
%ROOT%legacy-lens-server.exe %*
endlocal
